/*

*/

#include "usart.h"
#include "usart.h"

void USART0_Init(void)
{    
    rcu_periph_clock_enable(RCU_GPIOA);				//ʹGPIOAʱ
    rcu_periph_clock_enable(RCU_USART0);			//ʹUSART0ʱ
    
		//Usart0 TX GPIOA_9
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_10MHZ, GPIO_PIN_9);
		gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_9);	
		//Usart0 RX GPIOA_10
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_10MHZ, GPIO_PIN_10);
		gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_10);	
	
    usart_deinit(USART0);																			//ʼUSART0
    usart_baudrate_set(USART0, 115200U);											//115200
    usart_word_length_set(USART0, USART_WL_8BIT);							//8λ
    usart_stop_bit_set(USART0, USART_STB_1BIT);								//1ֹͣλ
    usart_parity_config(USART0, USART_PM_NONE);								//żУ
    usart_hardware_flow_rts_config(USART0, USART_RTS_DISABLE);//RTSعر
    usart_hardware_flow_cts_config(USART0, USART_CTS_DISABLE);//CTSعر
		usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);			//ʹUSART0
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);				//ʹUSART0	
		
		usart_interrupt_enable(USART0,USART_INT_RBNE);						//ʹж
		nvic_irq_enable(USART0_IRQn,2U);													//ʹжȼ
		usart_enable(USART0);																			//ʹUSART0
}
 
void USART0_Send_Byte(uint8_t Send_Byte)
{
    usart_data_transmit(USART0, Send_Byte);
    while ( usart_flag_get(USART0, USART_FLAG_TBE)== RESET) ;
}

void USART0_Send_Str(uint8_t *Str)
{
    while((*Str)!='\0')
    {
      USART0_Send_Byte(*Str);
      Str++;
    }
}


//void USART0_IRQHandler(void)
//{
//	  uint8_t i;
//    if (RESET != usart_interrupt_flag_get(USART0, USART_INT_FLAG_RBNE))   //ж
//    {
//        USART0_RECEIVE_Buf[i++] = (uint8_t)usart_data_receive(USART0);
//    }
//		else if(RESET != usart_interrupt_flag_get(USART0, USART_INT_FLAG_TBE))//ж
//    {
//				usart_interrupt_flag_clear(USART0,USART_INT_FLAG_IDLE);    
//    }
//}



#define u8 unsigned char

int UartGet (void)  
{ 

   // while (!(USART0->ISR & USART_INT_FLAG_RBNE));
		while(RESET==usart_interrupt_flag_get(USART0, USART_INT_FLAG_RBNE));
    //while(usart_flag_get(USART0, USART_FLAG_TBE) == RESET){};
    return (usart_data_receive(USART0));//TDR yiding gai RDR
			//return (uint16_t)(GET_BITS(USART_RDATA(USART_INT_FLAG_RBNE), 0U, 8U));
		
 } 


extern u8 rx_flag_finished;
extern u8 RX_BUF[];
extern u8 rx_count;
extern u8 ok;

void CheckBusy(void)  
{
	while(1)
	{
   if(ok==0x0f)
		 break;
	}		
	
	ok=0;
}

void get_var(unsigned char *val)
{	 
	for(;;)
	{ 
		if((RX_BUF[0]=='V')&&(RX_BUF[1]=='A')&&(RX_BUF[2]=='R'))
		{
			RX_BUF[0]=0;
			RX_BUF[1]=0;
			RX_BUF[2]=0;
			val[0]=RX_BUF[3];
			val[1]=RX_BUF[4];
			val[2]=RX_BUF[5];
			val[3]=RX_BUF[6];
			rx_flag_finished=0;	
			rx_count=0;
			break;				
		}	
	}

}
unsigned char ver[50];
u8 ver_index=0;
u8 ver_end=0;
char rch[5][3];     //xxx:xxx,xxx,xxx,xxx
u8 i=0;	
u8 p=0;//
u8 cmd=0;		//==1
u8 cmdok=0;	//==1 
u8 ok=0x00;
void getch(u8 c)
{	
	//======================
	//
	if(ver_index<50&&ver_end==0&&c!='\0'&&ok!=0x0f)
	{
		ver[ver_index]=c;
		ver_index++;
	}
	else
	{
		ver_end=1;
		ver_index=0;
	}
	//======================
	if (c=='{')
	{	i=0;
		cmd=1;
		p=0;
	}
	else if(c=='}')
	{	cmd=0;
		cmdok=1;
	}
	else if((c==':')||(c==','))
	{
			p++;
			i=0;
	}		
	else if (cmd==1)
	{	
		if (i<3) rch[p][i]=c;
		i++;
	}
	else	if(c=='O')
	{
		ok=(ok&0x00)|(0x01);
	}		
	else if(c=='K')
	{
		ok=(ok&0x0d)|(0x02);
	}	
  else if(c=='\r')
	{
		ok=(ok&0x0b)|(0x04);
	}
  else if(c=='\n')
	{
	 ok=(ok&0x07)|(0x08);
	}
	

}		

unsigned char val[4];
unsigned char GetValue(void)  
{	
	unsigned char m,n;
	while(1)
	{			
		if(cmdok==1)
		{			
			if ((rch[0][0]=='V')&&(rch[0][1]=='A')&&(rch[0][2]=='R'))
			{	
				/*һֽ*/
				if ((rch[1][2]>=0x30) && (rch[1][2]<=0x39))//100ϵ  
				{		
					val[0]=(rch[1][0]-0x30)*100+(rch[1][1]-0x30)*10+(rch[1][2]-0x30);
					
				}
				else if((rch[1][1]>=0x30) && (rch[1][1]<=0x39)) //10ϵ
				{
					val[0]=(rch[1][0]-0x30)*10+(rch[1][1]-0x30);
				}		
				else if((rch[1][0]>=0x30) && (rch[1][0]<=0x39))
				{
					val[0]=(rch[1][0]-0x30);						
				}
				/*ڶֽ*/
					if ((rch[2][2]>=0x30) && (rch[2][2]<=0x39))//100ϵ
				{		
					val[1]=(rch[2][0]-0x30)*100+(rch[2][1]-0x30)*10+(rch[2][2]-0x30);				
				}
				else if((rch[2][1]>=0x30) && (rch[2][1]<=0x39)) //10ϵ
				{
					val[1]=(rch[2][0]-0x30)*10+(rch[2][1]-0x30);
				}		
				else if((rch[2][0]>=0x30) && (rch[2][0]<=0x39))
				{
					val[1]=(rch[2][0]-0x30);						
				}
				
			/*ֽ*/
					if ((rch[3][2]>=0x30) && (rch[3][2]<=0x39))//100ϵ
				{		
					val[2]=(rch[3][0]-0x30)*100+(rch[3][1]-0x30)*10+(rch[3][2]-0x30);
					
				}
			
				else if((rch[3][1]>=0x30) && (rch[3][1]<=0x39)) //10ϵ
				{
					val[2]=(rch[3][0]-0x30)*10+(rch[3][1]-0x30);
				}		
				else if((rch[3][0]>=0x30) && (rch[3][0]<=0x39))
				{
					val[2]=(rch[3][0]-0x30);						
				}
				/*ĸֽ*/
					if ((rch[4][2]>=0x30) && (rch[4][2]<=0x39))//100ϵ
				{		
					val[3]=(rch[4][0]-0x30)*100+(rch[4][1]-0x30)*10+(rch[4][2]-0x30);
					
				}
			
				else if((rch[4][1]>=0x30) && (rch[4][1]<=0x39)) //10ϵ
				{
					val[3]=(rch[4][0]-0x30)*10+(rch[4][1]-0x30);
				}		
				else if((rch[4][0]>=0x30) && (rch[4][0]<=0x39))
				{
					val[3]=(rch[4][0]-0x30);						
				}		
				
			for(n=0;n<5;n++)
					for(m=0;m<3;m++)
				rch[n][m]=0;
				 cmdok=0;
					break;
				
				
		}
			//	cmdok=0;
			
		
		
	}	
		
 }
}
		
unsigned char GetKey(unsigned char *rval)  
{	
	unsigned char m,n;
	while(1)
	{			
		if(cmdok==1)
		{			
			if ((rch[0][0]=='U')&&(rch[0][1]=='P'))
			{		
				*rval=1;
						cmdok=0;
				for(n=0;n<5;n++)
					for(m=0;m<3;m++)
				rch[n][m]=0;
	
					break;	
				
			}
			else if ((rch[0][0]=='D')&&(rch[0][1]=='N'))
			{
						*rval=0;
				   cmdok=0;
				for(n=0;n<5;n++)
					for(m=0;m<3;m++)
				rch[n][m]=0;
					break;	
			}

		
		}
		
	}	
		
}	

u8 RX_BUF[4];
u8 rx_flag_finished=0;
u8 rx_count=0;	

void USART0_IRQHandler(void)
{
	  u8 Res=1;
	  uint8_t i;
    if (RESET != usart_interrupt_flag_get(USART0, USART_INT_FLAG_RBNE))   //ж
    {
       Res= usart_data_receive(USART0);

       getch(Res);			
    
   }
 }

 

void UartSend(char * databuf) 
{ 
	u8 i=0;
	while (1)
	{ 
		if ((*databuf)!=0)//ֱݶ 
	{ 
		usart_data_transmit(USART0, *databuf); //һֽ
		while(usart_flag_get(USART0, USART_FLAG_TBE) == RESET){}; //
		databuf++;//i++;
	}
	else return;
	}
}	




/*
void USART0_IRQHandler(void)                	//??1??????
{
	u8 Res=1;
	if(usart_interrupt_flag_get(USART0, USART_INT_FLAG_RBNE) != RESET)  //????(?????????0x0d 0x0a??)
	{
		Res= usart_data_receive(USART0);//(USART1->DR);	//????????
		getch(Res);
//		if(rx_flag_finished!=0xc0)//?????
//		{
//			if(rx_flag_finished&0x40)//????0x0d
//			{
//				if(Res==0x0a)
//				{
//					rx_flag_finished|=0x80;	//????? rx_flag_finished=0xc0
//					RX_BUF[rx_count]='\0'; //??????????????
//				}
//				else 
//				{
//					rx_flag_finished=0;//????,????					
//					rx_count=0;
//				}
//			}
//			else //????0X0D
//			{	
//				if(Res!=0x0d)
//				{
//					RX_BUF[rx_count++]=Res ;	
//				}
//				else
//				{
//					rx_flag_finished|=0x40;
//				}
//			}
//		}  
		
		

//		if(Res=='O')
//		busy_flag=0;
//		else
//		busy_flag=1;
  }
} 

*/






void USART1_Init(void)
{    
//    rcu_periph_clock_enable(RCU_GPIOA);				//ʹGPIOAʱ
//    rcu_periph_clock_enable(RCU_USART1);			//ʹUSART0ʱ
//    //USART1 TX GPIOA_2 
//    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_2);
//    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_10MHZ, GPIO_PIN_2);
//		gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_2);	
//		//USART1 RX GPIOA_3 
//    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_3);
//    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_10MHZ, GPIO_PIN_3);
//		gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_3);	
//	
//    usart_deinit(USART1);																			//USART1
//    usart_baudrate_set(USART1, 115200U);											//115200
//    usart_word_length_set(USART1, USART_WL_8BIT);							//8λλ
//    usart_stop_bit_set(USART1, USART_STB_1BIT);								//1λֹͣλ
//    usart_parity_config(USART1, USART_PM_NONE);								//żУλ
//    usart_hardware_flow_rts_config(USART1, USART_RTS_DISABLE);//RTSعر
//    usart_hardware_flow_cts_config(USART1, USART_CTS_DISABLE);//CTSعر
//		usart_transmit_config(USART1, USART_TRANSMIT_ENABLE);			//ʹUSART1
//    usart_receive_config(USART1, USART_RECEIVE_ENABLE);				//ʹUSART1		
// 
//		usart_interrupt_enable(USART1,USART_INT_RBNE);						//ʹUSART1ж
//		nvic_irq_enable(USART1_IRQn,2U);													//ʹUSART1жȼ
//		usart_enable(USART1);																			//ʹUSART0
}
 
void USART1_Send_Byte(uint8_t Send_Byte)
{
    usart_data_transmit(USART1, Send_Byte);
    while ( usart_flag_get(USART1, USART_FLAG_TBE)== RESET) ;
}

void USART1_Send_Str(uint8_t *Str)
{
    while((*Str)!='\0')
    {
      USART1_Send_Byte(*Str);
      Str++;
    }
}

void USART1_IRQHandler(void)
{
	  uint8_t i;
		if (RESET != usart_interrupt_flag_get(USART1, USART_INT_FLAG_RBNE))		 	//ж
    {
        USART0_RECEIVE_Buf[i++] = (uint8_t)usart_data_receive(USART1);
    }
		else if(RESET != usart_interrupt_flag_get(USART1, USART_INT_FLAG_TBE))  //ж
    {
        usart_interrupt_flag_clear(USART1,USART_INT_FLAG_IDLE);  
    }
}